/*
 * Decompiled with CFR 0.152.
 */
package com.hexsbm.screen;

import com.hexsbm.HexSBMClient;
import com.hexsbm.screen.pigment.PigmentColorRegistry;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_7923;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class SpellBookScreen
extends class_437 {
    private static final class_2960 SPELLBOOK_ID = new class_2960("hexcasting", "spellbook");
    private static final int GROUPS = 8;
    private static final int GROUP_SIZE = 8;
    private static final int TOTAL_PAGES = 64;
    private static final int R1_IN = 30;
    private static final int R1_OUT = 60;
    private static final int R2_IN = 70;
    private static final int R2_OUT = 110;
    private int pigmentColor = -1;
    private class_1268 activeHand = null;
    private boolean selectionConfirmed = false;
    private int centralGroup = 0;
    private int originalPageIdx = -1;
    private static final Set<String> VISUAL_TAGS = Set.of("Enchantments", "display", "CustomPotionColor", "Potion", "SkullOwner", "EntityTag", "hexcasting:pattern_data", "hexcasting:amulet_state", "hexcasting:op_code", "patchouli:book", "op_id");

    public SpellBookScreen() {
        super((class_2561)class_2561.method_43473());
    }

    public void method_25426() {
        class_2487 pigment;
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            this.method_25419();
            return;
        }
        class_746 p = this.field_22787.field_1724;
        class_2487 nbt = p.method_5647(new class_2487());
        class_2487 cc = nbt.method_10562("cardinal_components");
        if (cc.method_10573("hexcasting:favored_pigment", 10) && (pigment = cc.method_10562("hexcasting:favored_pigment")).method_10573("pigment", 10)) {
            String id = pigment.method_10562("pigment").method_10562("stack").method_10558("id");
            this.pigmentColor = PigmentColorRegistry.getColor(id);
        }
        class_1799 main = p.method_6047();
        class_1799 off = p.method_6079();
        if (!main.method_7960() && class_7923.field_41178.method_10221((Object)main.method_7909()).equals((Object)SPELLBOOK_ID)) {
            this.activeHand = class_1268.field_5808;
            this.originalPageIdx = this.getBookPage(main);
        } else if (!off.method_7960() && class_7923.field_41178.method_10221((Object)off.method_7909()).equals((Object)SPELLBOOK_ID)) {
            this.activeHand = class_1268.field_5810;
            this.originalPageIdx = this.getBookPage(off);
        } else {
            this.method_25419();
            return;
        }
        if (this.originalPageIdx != -1) {
            this.centralGroup = Math.max(0, Math.min(7, (this.originalPageIdx - 1) / 8));
        }
    }

    private int getBookPage(class_1799 book) {
        class_2487 nbt = book.method_7969();
        return nbt != null && nbt.method_10573("page_idx", 3) ? nbt.method_10550("page_idx") : 1;
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25394(class_332 ctx, int mx, int my, float delta) {
        class_1799 icon;
        int y;
        int x;
        int i;
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            this.method_25419();
            return;
        }
        class_1799 book = this.getCurrentBook();
        int currentPage = book.method_7960() ? 1 : this.getBookPage(book);
        int cx = this.field_22789 / 2;
        int cy = this.field_22790 / 2;
        for (i = 0; i < 8; ++i) {
            int innerCol;
            int page = this.centralGroup * 8 + i + 1;
            if (page > 64) continue;
            SectorAngles ang = new SectorAngles(i);
            boolean cur = page == currentPage;
            boolean hover = this.isPointInSegment(mx, my, cx, cy, 70, 110, ang.start, ang.end);
            int n = cur ? this.mkColor(153, this.lighten(this.pigmentColor, 0.15f)) : (innerCol = hover ? this.mkColor(144, this.lighten(this.pigmentColor, 0.25f)) : this.mkColor(128, this.darken(this.pigmentColor, 0.1f)));
            int outerCol = cur ? this.mkColor(153, this.lighten(this.pigmentColor, 0.15f)) : (hover ? this.mkColor(144, this.lighten(this.pigmentColor, 0.25f)) : this.mkColor(128, this.lighten(this.pigmentColor, 0.1f)));
            this.fillSegment(ctx, cx, cy, 70, 110, ang.start, ang.end, innerCol, outerCol);
            x = (int)((double)cx + 90.0 * Math.cos(ang.mid));
            y = (int)((double)cy + 90.0 * Math.sin(ang.mid));
            icon = this.getPageIcon(book, page);
            if (!icon.method_7960()) {
                ctx.method_51427(icon, x - 8, y - 8);
            }
            if (!hover) continue;
            ArrayList<Object> tip = new ArrayList<Object>();
            String name = this.getCustomPageName(book, page);
            tip.add(class_2561.method_43470((String)(name != null && !name.isEmpty() ? name : "Page " + page)));
            tip.addAll(this.getPatternTooltip(book, page));
            ctx.method_51434(this.field_22793, tip, mx, my);
        }
        for (i = 0; i < 8; ++i) {
            int innerCol;
            SectorAngles ang = new SectorAngles(i);
            boolean cur = i == this.centralGroup;
            boolean hover = this.isPointInSegment(mx, my, cx, cy, 30, 60, ang.start, ang.end);
            int n = cur ? this.mkColor(153, this.lighten(this.pigmentColor, 0.15f)) : (innerCol = hover ? this.mkColor(144, this.lighten(this.pigmentColor, 0.25f)) : this.mkColor(128, this.lighten(this.pigmentColor, 0.15f)));
            int outerCol = cur ? this.mkColor(153, this.lighten(this.pigmentColor, 0.2f)) : (hover ? this.mkColor(144, this.lighten(this.pigmentColor, 0.25f)) : this.mkColor(128, this.darken(this.pigmentColor, 0.1f)));
            this.fillSegment(ctx, cx, cy, 30, 60, ang.start, ang.end, innerCol, outerCol);
            int r = 45;
            x = (int)((double)cx + (double)r * Math.cos(ang.mid));
            y = (int)((double)cy + (double)r * Math.sin(ang.mid));
            icon = this.getGroupIcon(book, i);
            if (icon.method_7960()) continue;
            ctx.method_51427(icon, x - 8, y - 8);
        }
    }

    private int mkColor(int alpha, int rgb) {
        return alpha << 24 | rgb & 0xFFFFFF;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.field_22787 == null || this.field_22787.field_1724 == null || this.activeHand == null) {
            this.method_25419();
            return true;
        }
        int cx = this.field_22789 / 2;
        int cy = this.field_22790 / 2;
        int mx = (int)mouseX;
        int my = (int)mouseY;
        if (button == 0) {
            int i;
            for (i = 0; i < 8; ++i) {
                SectorAngles ang = new SectorAngles(i);
                if (!this.isPointInSegment(mx, my, cx, cy, 30, 60, ang.start, ang.end)) continue;
                this.centralGroup = i;
                return true;
            }
            for (i = 0; i < 8; ++i) {
                int page = this.centralGroup * 8 + i + 1;
                if (page > 64) continue;
                SectorAngles ang = new SectorAngles(i);
                if (!this.isPointInSegment(mx, my, cx, cy, 70, 110, ang.start, ang.end)) continue;
                this.selectionConfirmed = true;
                HexSBMClient.sendChangeSpellbookPage(this.activeHand, page);
                this.method_25419();
                return true;
            }
            this.method_25419();
            return true;
        }
        if (button == 1) {
            int i;
            class_1799 book = this.getCurrentBook();
            if (book.method_7960()) {
                return false;
            }
            for (i = 0; i < 8; ++i) {
                SectorAngles ang = new SectorAngles(i);
                if (!this.isPointInSegment(mx, my, cx, cy, 30, 60, ang.start, ang.end)) continue;
                this.updateGroupIcon(book, i);
                return true;
            }
            for (i = 0; i < 8; ++i) {
                int page = this.centralGroup * 8 + i + 1;
                if (page > 64) continue;
                SectorAngles ang = new SectorAngles(i);
                if (!this.isPointInSegment(mx, my, cx, cy, 70, 110, ang.start, ang.end)) continue;
                this.updatePageIcon(book, page);
                return true;
            }
        }
        return true;
    }

    private void updateGroupIcon(class_1799 book, int idx) {
        class_746 p = this.field_22787.field_1724;
        class_1799 src = SpellBookScreen.makeIconOnly(p.method_31548().method_5438(p.method_31548().field_7545));
        this.updateIcon(book, "group_icons", idx, src);
        HexSBMClient.sendUpdateGroupIcon(this.activeHand, idx, src);
    }

    private void updatePageIcon(class_1799 book, int page) {
        class_746 p = this.field_22787.field_1724;
        class_1799 src = SpellBookScreen.makeIconOnly(p.method_31548().method_5438(p.method_31548().field_7545));
        this.updateIcon(book, "page_icons", page, src);
        HexSBMClient.sendUpdatePageIcon(this.activeHand, page, src);
    }

    private void updateIcon(class_1799 book, String key, int idx, class_1799 icon) {
        class_2487 nbt = book.method_7948();
        class_2487 map = nbt.method_10562(key);
        String s = String.valueOf(idx);
        if (!icon.method_7960()) {
            map.method_10566(s, (class_2520)icon.method_7953(new class_2487()));
        } else {
            map.method_10551(s);
        }
        nbt.method_10566(key, (class_2520)map);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(null);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int mods) {
        if (keyCode == 86 || keyCode == 256) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, mods);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.field_22787 == null || this.field_22787.field_1724 == null || this.activeHand == null) {
            return false;
        }
        if (this.activeHand == class_1268.field_5810) {
            int newSlot;
            class_1661 inv = this.field_22787.field_1724.method_31548();
            int current = inv.field_7545;
            inv.field_7545 = newSlot = amount > 0.0 ? (current == 0 ? 8 : current - 1) : (current == 8 ? 0 : current + 1);
            return true;
        }
        return false;
    }

    private class_1799 getCurrentBook() {
        class_746 p = this.field_22787.field_1724;
        if (!p.method_6047().method_7960() && class_7923.field_41178.method_10221((Object)p.method_6047().method_7909()).equals((Object)SPELLBOOK_ID)) {
            return p.method_6047();
        }
        if (!p.method_6079().method_7960() && class_7923.field_41178.method_10221((Object)p.method_6079().method_7909()).equals((Object)SPELLBOOK_ID)) {
            return p.method_6079();
        }
        return class_1799.field_8037;
    }

    private class_1799 getPageIcon(class_1799 book, int page) {
        return this.getIcon(book, "page_icons", page);
    }

    private class_1799 getGroupIcon(class_1799 book, int group) {
        return this.getIcon(book, "group_icons", group);
    }

    private class_1799 getIcon(class_1799 book, String key, int idx) {
        String s;
        class_2487 nbt = book.method_7969();
        if (nbt == null || !nbt.method_10573(key, 10)) {
            return class_1799.field_8037;
        }
        class_2487 map = nbt.method_10562(key);
        if (!map.method_10573(s = String.valueOf(idx), 10)) {
            return class_1799.field_8037;
        }
        try {
            return class_1799.method_7915((class_2487)map.method_10562(s));
        }
        catch (Exception e) {
            return class_1799.field_8037;
        }
    }

    private static class_1799 makeIconOnly(class_1799 src) {
        if (src.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 icon = new class_1799((class_1935)src.method_7909(), 1);
        class_2487 tag = src.method_7969();
        if (tag != null) {
            class_2487 clean = new class_2487();
            for (String k : VISUAL_TAGS) {
                if (!tag.method_10545(k)) continue;
                clean.method_10566(k, tag.method_10580(k).method_10707());
            }
            if (!clean.method_33133()) {
                icon.method_7980(clean);
            }
        }
        return icon;
    }

    private boolean isPointInSegment(int px, int py, int cx, int cy, int rIn, int rOut, double a1, double a2) {
        double e;
        double dx = px - cx;
        double dy = py - cy;
        double dist = Math.sqrt(dx * dx + dy * dy);
        if (dist < (double)rIn || dist > (double)rOut) {
            return false;
        }
        double angle = Math.atan2(dy, dx);
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        double s = a1 < 0.0 ? a1 + Math.PI * 2 : a1;
        double d = e = a2 < 0.0 ? a2 + Math.PI * 2 : a2;
        return s < e ? angle >= s && angle <= e : angle >= s || angle <= e;
    }

    private String getCustomPageName(class_1799 book, int page) {
        class_2487 nbt = book.method_7969();
        if (nbt == null || !nbt.method_10573("page_names", 10)) {
            return null;
        }
        String json = nbt.method_10562("page_names").method_10558(String.valueOf(page));
        try {
            class_5250 t = class_2561.class_2562.method_10877((String)json);
            return t != null ? t.getString() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private List<class_2561> getPatternTooltip(class_1799 book, int page) {
        class_2487 nbt = book.method_7969();
        if (nbt == null || !nbt.method_10573("pages", 10)) {
            return Collections.emptyList();
        }
        class_2487 pages = nbt.method_10562("pages");
        if (!pages.method_10573(String.valueOf(page), 10)) {
            return Collections.emptyList();
        }
        class_1799 fake = book.method_7972();
        fake.method_7948().method_10569("page_idx", page);
        List tt = fake.method_7950((class_1657)this.field_22787.field_1724, (class_1836)class_1836.class_1837.field_41070);
        return tt.size() >= 3 ? List.of((class_2561)tt.get(2)) : Collections.emptyList();
    }

    private void fillSegment(class_332 ctx, int cx, int cy, int rIn, int rOut, double a1, double a2, int cIn, int cOut) {
        Matrix4f m = ctx.method_51448().method_23760().method_23761();
        class_289 t = class_289.method_1348();
        class_287 b = t.method_1349();
        float ir = (float)(cIn >> 16 & 0xFF) / 255.0f;
        float ig = (float)(cIn >> 8 & 0xFF) / 255.0f;
        float ib = (float)(cIn & 0xFF) / 255.0f;
        float ia = (float)(cIn >> 24 & 0xFF) / 255.0f;
        float or = (float)(cOut >> 16 & 0xFF) / 255.0f;
        float og = (float)(cOut >> 8 & 0xFF) / 255.0f;
        float ob = (float)(cOut & 0xFF) / 255.0f;
        float oa = (float)(cOut >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int seg = Math.max(4, (int)((a2 - a1) / 0.10471975511965977));
        b.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
        for (int i = 0; i <= seg; ++i) {
            double a = class_3532.method_16436((double)((double)i / (double)seg), (double)a1, (double)a2);
            float cos = (float)Math.cos(a);
            float sin = (float)Math.sin(a);
            b.method_22918(m, (float)cx + (float)rOut * cos, (float)cy + (float)rOut * sin, 0.0f).method_22915(or, og, ob, oa).method_1344();
            b.method_22918(m, (float)cx + (float)rIn * cos, (float)cy + (float)rIn * sin, 0.0f).method_22915(ir, ig, ib, ia).method_1344();
        }
        t.method_1350();
        RenderSystem.disableBlend();
    }

    private int lighten(int color, float f) {
        float r = Math.min(1.0f, (float)(color >> 16 & 0xFF) / 255.0f + f);
        float g = Math.min(1.0f, (float)(color >> 8 & 0xFF) / 255.0f + f);
        float b = Math.min(1.0f, (float)(color & 0xFF) / 255.0f + f);
        return color & 0xFF000000 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
    }

    private int darken(int color, float f) {
        float r = Math.max(0.0f, (float)(color >> 16 & 0xFF) / 255.0f - f);
        float g = Math.max(0.0f, (float)(color >> 8 & 0xFF) / 255.0f - f);
        float b = Math.max(0.0f, (float)(color & 0xFF) / 255.0f - f);
        return color & 0xFF000000 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
    }

    @Environment(value=EnvType.CLIENT)
    private static class SectorAngles {
        final double start;
        final double mid;
        final double end;

        SectorAngles(int i) {
            double w = 0.7853981633974483;
            this.mid = -1.5707963267948966 + w * (double)i;
            this.start = this.mid - w / 2.0;
            this.end = this.mid + w / 2.0;
        }
    }
}

